extern int Exe; //0 = game.exe, 1 = server.dat, 2 = RH73 LFDS, 3 = RH8 LFDS, 4 = leveledit, 6 = invalid
void InitEngine(); //initalize pointers to engine functions
GameObject *Get_GameObj(int ID); //convert a player ID into a GameObject
int Get_Player_ID(GameObject *obj); //convert a GameObject into a player ID
const char *Get_Model(GameObject *obj); //get the name of the 3d model used by an object, opposite of Set_Model
int Get_Object_Type(GameObject *obj); //get the team of an object, 0 = Nod, 1 = GDI, 2 = neutral, works on buildings
bool Change_Character(GameObject *obj,const char *Preset_Name); //will change the character of the passed in object to the passed in preset
const char *Get_Player_Name(GameObject *obj); //converts a GameObject into a player name
GameObject *Find_Building_By_Team(int Team); //finds the first building of this team, 0 = Nod, 1 = GDI
GameObject *Find_Building_By_Name(int Team, const char *Preset_Name); //finds the first building of team where preset name matches name, 0 = Nod, 1 = GDI
void Kill_All_Buildings_By_Team(int Team); //kill all buildings of the specified team, ending the game with the other team winning, 0 = Nod, 1 = GDI
void Damage_All_Buildings_By_Team(int Team,float Damage,const char *Warhead,GameObject *Damager); //damages all buildings of the specified team, the Damager is the object that will be passed to the Damaged callback for the buildings and also the one that will get the points, 0 = Nod, 1 = GDI, 2 = both
void Repair_All_Buildings_By_Team(int Team,int ConstructionYardID,float Health); //repairs all buildings for the team except the passed in ConstructionYardID, 0 = Nod, 1 = GDI
void Repair_All_Static_Vehicles_By_Team(int Team,int Message); //sends a custom to all vechicles of the team with the DecorationPhys physics type (i.e. all base defence vechicles etc), 0 = Nod, 1 = GDI, Message is the message to send. Use with JFW_Repair_On_Custom on the vechicles you want repaired to do the actual repairing
GameObject *Find_Smart_Object_By_Team(int Team); //will find the first SmartGameObj (i.e. soldier or vechicle) for the team, 0 = Nod, 1 = GDI
GameObject *Find_Object_By_Team(int Team); //will find the first object for the team, 0 = Nod, 1 = GDI
GameObject *Find_Non_Player_Object_By_Team(int Team); //will find the first non player object for the team, 0 = Nod, 1 = GDI
GameObject *Find_Object_By_Preset(int Team,const char *Preset_Name); //will find the first object of team matching preset, 0 = Nod, 1 = GDI, 2 = either
GameObject *Find_Power_Plant(int Team); //finds the first powerplant for Team, 0 = Nod, 1 = GDI, 2 = either
GameObject *Find_Refinery(int Team); //finds the first refinery for Team, 0 = Nod, 1 = GDI, 2 = either
GameObject *Find_Repair_Bay(int Team); //finds the first repair bay for Team, 0 = Nod, 1 = GDI, 2 = either
GameObject *Find_Soldier_Factory(int Team); //finds the first soldier factory for Team, 0 = Nod, 1 = GDI, 2 = either
GameObject *Find_Airstrip(int Team); //finds the first airstrip for Team, 0 = Nod, 1 = GDI, 2 = either
GameObject *Find_War_Factory(int Team); //finds the first war factory for Team, 0 = Nod, 1 = GDI, 2 = either
GameObject *Find_Vehicle_Factory(int Team); //finds the first airstrip for Team, if none is found, finds the first war factory for Team, 0 = Nod, 1 = GDI, 2 = either
GameObject *Find_Com_Center(int Team); //finds the first communications center for Team, 0 = Nod, 1 = GDI, 2 = either
bool Is_Building(GameObject *obj); //is a BuildingGameObj
bool Is_Soldier(GameObject *obj); //is a SoldierGameObj
bool Is_Vehicle(GameObject *obj); //is a VechicleGameObj
bool Is_Cinematic(GameObject *obj); //is a CinematicGameObj
bool Is_ScriptZone(GameObject *obj); //is a ScriptZoneGameObj
void Set_Max_Health(GameObject *obj,float health); //set the max health of obj
void Set_Max_Shield_Strength(GameObject *obj,float shieldstrength); //set the max shield strength of obj
GameObject *Find_First_Player(int Team); //finds the first player of Team, 0 = Nod, 1 = GDI, 2 = either
float Get_Animation_Frame(GameObject *obj); //gets the current animation frame for obj, may not work for all objects
void Grant_Refill(GameObject *obj); //triggers the same code as the refill button on the PT
void Grant_Powerup(GameObject *obj,const char *Preset_Name); //grants a powerup
GameObject *Get_Vehicle(GameObject *obj); //gets the vechicle that obj is driving
const char *Get_Shield_Type(GameObject *obj); //gets the shield type of obj, this for some wierd reason wont work, I dont know why
const char *Get_Skin(GameObject *obj); //gets the skin type of obj, this for some wierd reason wont work, I dont know why
void Set_Skin(GameObject *obj,const char *Skintype); //sets the skin type of obj, this for some wierd reason wont work, I dont know why
void Create_Vehicle(const char *Preset_Name, float Delay, GameObject *Owner, int Team); //creates a vechicle, dont know what Delay is for, Owner is for the owner of the vechicle, Team says which sides factories to create it at
void Toggle_Fly_Mode(GameObject *obj); //makes a soldier fly if they arent flying or not fly if they are
void Console_Input(const char *Input); //triggers console input (i.e. passes the string in as though it was typed into the console)
void Console_Output(const char *Output); //prints stuff to the console
bool Is_TrackedVehicle(GameObject *obj); //has TrackedVechicle physics
bool Is_VTOLVehicle(GameObject *obj); //has VTOLVechicle physics
bool Is_WheeledVehicle(GameObject *obj); //has WheeledVechicle physics
bool Is_Motorcycle(GameObject *obj); //has Morotcycle physics
bool Is_Door(GameObject *obj); //has Door physics
bool Is_Elevator(GameObject *obj); //has Elevator physics
bool Is_DamageableStaticPhys(GameObject *obj); //has DamageableStaticPhys physics
bool Is_AccessablePhys(GameObject *obj); //has AccessablePhys physics
bool Is_DecorationPhys(GameObject *obj); //has DecorationPhys physics
bool Is_HumanPhys(GameObject *obj); //has HumanPhys physics
bool Is_MotorVehicle(GameObject *obj); //has MotorVehicle physics
bool Is_Phys3(GameObject *obj); //has Phys3 physics
bool Is_RigidBody(GameObject *obj); //has RigidBody physics
bool Is_ShakeableStatricPhys(GameObject *obj); //has ShakeableStaticPhys physics
bool Is_StaticAnimPhys(GameObject *obj); //has StaticAnimPhys physics
bool Is_StaticPhys(GameObject *obj); //has StaticPhys physics
bool Is_TimedDecorationPhys(GameObject *obj); //has TimedDecorationPhys physics
bool Is_VehiclePhys(GameObject *obj); //has VechiclePhys physics
bool Is_DynamicAnimPhys(GameObject *obj); //has DenamicAnimPhys physics
bool Is_BuildingAggregate(GameObject *obj); //has BuildingAggregate physics
bool Is_Projectile(GameObject *obj); //has Projectile physics
const char *Get_Player_Name_By_ID(int ID); //gets the player name from a player ID
void Change_Team(GameObject *obj,int Team); //changes the team of a player given their ID and also kills the player so they respwan, passing anything other than 0 = Nod, 1 = GDI will crash
void Change_Team_By_ID(int ID,int Team); //changes the team of a player given their GameObject and also kills the player so they respwan, passing anything other than 0 = Nod, 1 = GDI will crash
int Get_Player_Count(); //gets the count of how many players there are
bool Is_Powerup(GameObject *obj); //is a PowerUpGameObj
bool Is_C4(GameObject *obj); //is a C4GameObj
bool Is_Beacon(GameObject *obj); //is a BeaconGameObj
bool Is_Armed(GameObject *obj); //is an ArmedGameObj
bool Is_Simple(GameObject *obj); //is a SimpleGameObj
bool Is_PowerPlant(GameObject *obj); //is a PowerPlantGameObj
bool Is_SoldierFactory(GameObject *obj); //is a SoldierFactoryGameObj
bool Is_VehicleFactory(GameObject *obj); //is a VehicleFactoryGameObj
bool Is_Airstrip(GameObject *obj); //is an AirstripGameObj
bool Is_WarFactory(GameObject *obj); //is a WarFactoryGameObj
bool Is_Refinery(GameObject *obj); //is a RefineryGameObj
bool Is_ComCenter(GameObject *obj); //is a ComCenterGameObj
bool Is_RepairBay(GameObject *obj); //is a RepairBayGameObj
void Damage_All_Vehicles_Area(float Damage,const char *Warhead,const Vector3 &Position,float Distance,GameObject *Host,GameObject *Damager); //damages all vechicles in a given area except the host
void Damage_All_Objects_Area(float Damage,const char *Warhead,const Vector3 &Position,float Distance,GameObject *Host,GameObject *Damager); //damages all objects in a given area except the host
int Get_Team_Player_Count(int Team); //gets the count of players for a given team, 0 = Nod, 1 = GDI)
const char *Get_Physics(GameObject *obj); //returns a string indicating the physics type of an object
const char *Get_Building_Type(GameObject *obj); //returns a string indicating the building type of an object
void Disarm_Nearest_Beacon(GameObject *Host, int Team, bool Nearest); //disarms the nearest beacon
bool Change_Player_Team(GameObject *obj, bool Retain_Score, bool Retain_Money, bool Show_Host_Message); //changes the players team
//start per-player script commands stuff
typedef void (*_Set_Background_Music_Player) (GameObject *obj,const char *music);
typedef void (*_Fade_Background_Music_Player) (GameObject *obj,const char *music,int unk1,int unk2);
typedef void (*_Stop_Background_Music_Player) (GameObject *obj);
typedef void (*_Enable_Radar_Player) (GameObject *obj,bool enable);
typedef void (*_Display_GDI_Player_Terminal_Player) (GameObject *obj);
typedef void (*_Display_NOD_Player_Terminal_Player) (GameObject *obj);
typedef void (*_Set_Screen_Fade_Color_Player) (GameObject *obj,float red,float green,float blue,float transition);
typedef void (*_Set_Screen_Fade_Opacity_Player) (GameObject *obj,float opacity,float transition);
extern _Set_Background_Music_Player Set_Background_Music_Player;
extern _Fade_Background_Music_Player Fade_Background_Music_Player;
extern _Stop_Background_Music_Player Stop_Background_Music_Player;
extern _Enable_Radar_Player Enable_Radar_Player;
extern _Display_GDI_Player_Terminal_Player Display_GDI_Player_Terminal_Player;
extern _Display_NOD_Player_Terminal_Player Display_NOD_Player_Terminal_Player;
extern _Set_Screen_Fade_Color_Player Set_Screen_Fade_Color_Player;
extern _Set_Screen_Fade_Opacity_Player Set_Screen_Fade_Opacity_Player;
//these only do damage if the building is close enough
void Ranged_Damage_To_Buildings(float Damage,const char *Warhead,Vector3 Location,float DamageRadius,GameObject *Damager); //damage buildings
void Ranged_Scale_Damage_To_Buildings(float Damage,const char *Warhead,Vector3 Location,float DamageRadius,GameObject *Damager); //damage buildings based on a scale factor
void Ranged_Percentage_Damage_To_Buildings(float Percentage,const char *Warhead,Vector3 Location,float DamageRadius,GameObject *Damager); //damage buildings based on a percentage factor
void Ranged_Damage_To_Buildings_Team(int Team,float Damage,const char *Warhead,Vector3 Location,float DamageRadius,GameObject *Damager); //damage buildings per team
void Ranged_Scale_Damage_To_Buildings_Team(int Team,float Damage,const char *Warhead,Vector3 Location,float DamageRadius,GameObject *Damager); //damage buildings per team based on a scale factor
void Ranged_Percentage_Damage_To_Buildings_Team(int Team,float Percentage,const char *Warhead,Vector3 Location,float DamageRadius,GameObject *Damager); //damage buildings per team based on a percentage factor
void Send_Custom_To_Team_Buildings(int Team, GameObject *sender,int message,int param,float delay); //send custom to team buildings
void Send_Custom_To_Team_Preset(int Team, const char *PresetName,GameObject *sender,int message,int param,float delay); //send custom to team preset
void Enable_Team_Radar(int Team,bool Enable); //enable radar for a given team
GameObject *Find_Base_Defense(int Team); //will find the AGT or the Obelisk, based on what team is sent, 0 = Nod, 1 = GDI
int Get_Beacon_Count(int Team);
int Get_C4_Count(int Team);
GameObject *Find_Beacon(int Number, int Team);
GameObject *Get_Beacon_Object(GameObject *obj);
GameObject *Get_Beacon_By_Position(Vector3 &pos);
GameObject *Get_Beacon_Planter(GameObject *BeaconObj);
void Damage_Objects_Half();
void Kill_Stealth();
void Setup_Show_Stealth();